package gov.va.med.mhv.usermgmt.web.formbean;

import gov.va.med.mhv.usermgmt.common.enums.CountryEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.StateEnumeration;

import java.io.Serializable;
import java.util.Locale;

public class EmergencyContact implements Serializable {
	private static final long serialVersionUID = 7534157158201354991L;

	private Long emergencyContactId;
	private String firstName;
	private String middleName;
	private String lastName;
	private String title;
	private String relationShip;
	private Integer priority;
	private Boolean primary;
	private String street1;
	private String street2;
	private String city;
	private String state;
	private String postalCode;
	private String province;
	private String country;
	private String homePhone;
	private String workPhone;
	private String workPhoneExt;
	private String mobilePhone;
	private String fax;
	private String pager;
	private String email;
	private String contactMethod;
	private String suffix;
	private Long userProfileId;
	
	public String getRelationShip() {
		return relationShip;
	}
	public void setRelationShip(String relationShip) {
		this.relationShip = relationShip;
	}
	public Integer getPriority() {
		return priority;
	}
	public void setPriority(Integer priority) {
		this.priority = priority;
	}
	public Boolean getPrimary() {
		return primary;
	}
	public void setPrimary(Boolean primary) {
		this.primary = primary;
	}
	public String getStreet1() {
		return street1;
	}
	public void setStreet1(String street1) {
		this.street1 = street1;
	}
	public String getStreet2() {
		return street2;
	}
	public void setStreet2(String street2) {
		this.street2 = street2;
	}
	public String getCity() {
		return city;
	}
	public void setCity(String city) {
		this.city = city;
	}
	public String getState() {
		return state;
	}
	public void setState(String state) {
		this.state = state;
	}
	public String getPostalCode() {
		return postalCode;
	}
	public void setPostalCode(String postalCode) {
		this.postalCode = postalCode;
	}
	public String getProvince() {
		return province;
	}
	public void setProvince(String province) {
		this.province = province;
	}
	public String getCountry() {
		return country;
	}
	public void setCountry(String country) {
		this.country = country;
	}
	public String getHomePhone() {
		return homePhone;
	}
	public void setHomePhone(String homePhone) {
		this.homePhone = homePhone;
	}
	public String getWorkPhone() {
		return workPhone;
	}
	public void setWorkPhone(String workPhone) {
		this.workPhone = workPhone;
	}
	public String getWorkPhoneExt() {
		return workPhoneExt;
	}
	public void setWorkPhoneExt(String workPhoneExt) {
		this.workPhoneExt = workPhoneExt;
	}
	public String getMobilePhone() {
		return mobilePhone;
	}
	public void setMobilePhone(String mobilePhone) {
		this.mobilePhone = mobilePhone;
	}
	public String getFax() {
		return fax;
	}
	public void setFax(String fax) {
		this.fax = fax;
	}
	public String getPager() {
		return pager;
	}
	public void setPager(String pager) {
		this.pager = pager;
	}
	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}
	public Long getEmergencyContactId() {
		return emergencyContactId;
	}
	public void setEmergencyContactId(Long emergencyContactId) {
		this.emergencyContactId = emergencyContactId;
	}
	public String getFirstName() {
		return firstName;
	}
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	public String getMiddleName() {
		return middleName;
	}
	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}
	public String getLastName() {
		return lastName;
	}
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public String getContactMethod() {
		return contactMethod;
	}
	public void setContactMethod(String contactMethod) {
		this.contactMethod = contactMethod;
	}
	
	public String getDisplayContactMethod() {
		String initialContactMethod = contactMethod;
		String firstChar = initialContactMethod.substring(0, 1);
		return initialContactMethod +" ("+firstChar+")";
		
	}
	
	public String getCurrentContactInfo() {
		// Defect 446138: Portability Flaw: Locale Dependent Comparison (Fortify base scan)
    	Locale.setDefault(Locale.ENGLISH);
    	
		if( contactMethod != null ) {
			if("email".equals(contactMethod.toLowerCase()) ) {
				return this.email;
			} else if( "fax".equals(contactMethod.toLowerCase()) ) {
				return this.fax;
			} else if( "pager".equals(contactMethod.toLowerCase()) ) {
				return this.pager;
			} else if( "work phone".equals(contactMethod.toLowerCase()) ) {
				return this.workPhone;
			} else if( "mobile phone".equals(contactMethod.toLowerCase()) ) {
				return this.mobilePhone;
			} else if( "home phone".equals(contactMethod.toLowerCase()) ) {
				return this.homePhone;
			}
		}
		return "";
	}
	public String getSuffix() {
		return suffix;
	}
	public void setSuffix(String suffix) {
		this.suffix = suffix;
	}
	public Long getUserProfileId() {
		return userProfileId;
	}
	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}
	
	public CountryEnumeration[] getCountries() {
		return CountryEnumeration.values();
	}

	public StateEnumeration[] getStates() {
		return StateEnumeration.values();
	}
}
